#include "Premenne.h"
#include "Zdroje.h"
#include "Funkcie.h"


/*
DWORD WINAPI ThreadProc(LPVOID lpParam) 
{
    DWORD dwMask, readen, dwError;
    COMSTAT cs;
    OVERLAPPED osWait = { 0 }, osRead = { 0 };
    
    osWait.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
    osRead.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
    
    // Masku nastavme raz pred cyklom
    SetCommMask(ComHandle, EV_RXCHAR);

    while (StavPripojeniaCOM)
    {
        // 1. akanie na udalos (prchod dt)
        if (!WaitCommEvent(ComHandle, &dwMask, &osWait)) 
        {
            if (GetLastError() == ERROR_IO_PENDING) 
                WaitForSingleObject(osWait.hEvent, INFINITE);
            else {
                Sleep(10); // Prevencia pred CPU zaou pri chybe
                continue;
            }
        }

        if (dwMask & EV_RXCHAR) 
        {
            // 2. Zistme, koko znakov relne ak v buferi
            ClearCommError(ComHandle, &dwError, &cs);
            
            if (cs.cbInQue > 0) 
            {
                // tame len to, o tam je (max do vekosti RXbufer - 1)
                DWORD toRead = (cs.cbInQue > 2027) ? 2027 : cs.cbInQue;

                if (!ReadFile(ComHandle, RXbufer, toRead, &readen, &osRead)) 
                {
                    if (GetLastError() == ERROR_IO_PENDING) 
                    {
                        WaitForSingleObject(osRead.hEvent, 500); // Krat timeout postauje
                        GetOverlappedResult(ComHandle, &osRead, &readen, FALSE);
                    }
                }

                if (readen > 0) 
                {
                    RXbufer[readen] = '\0'; 
                    SendMessage(g_hwndDlg, WM_RXCHAR, (WPARAM)readen, 0);
                }
            }
        }
        
        ResetEvent(osWait.hEvent);
        // Voliten: ClearCommError aj tu pre premazanie chb (overrun a pod.)
        ClearCommError(ComHandle, &dwError, &cs);
    }

    // Upratovanie pri ukonen vlkna
    CloseHandle(osWait.hEvent);
    CloseHandle(osRead.hEvent);
    return 0;
}
//*/
//*
DWORD WINAPI ThreadProc(LPVOID lpParam) 
{
	int pocet_znakov;
    DWORD dwMask, readen;
    COMMTIMEOUTS timeouts = { 0 };
    OVERLAPPED osWait = { 0 }, osRead = { 0 };
    
    osWait.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
    // Pouijeme druh truktru pre ReadFile, aby sa nekriovali
    osRead.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
    
    // Kov: 50ms pauza medzi znakmi ukon ReadFile
    timeouts.ReadIntervalTimeout = 50; 
    timeouts.ReadTotalTimeoutConstant = 50;
    timeouts.ReadTotalTimeoutMultiplier = 10;
    SetCommTimeouts(ComHandle, &timeouts);

    SetCommMask(ComHandle, EV_RXCHAR);

    while (StavPripojeniaCOM)
    {
        // 1. akme na nznak dt (prv bajt)
        if (!WaitCommEvent(ComHandle, &dwMask, &osWait)) 
            if (GetLastError() == ERROR_IO_PENDING) 
                WaitForSingleObject(osWait.hEvent, INFINITE);
 
        if (dwMask & EV_RXCHAR) 
        {
            if (!ReadFile(ComHandle, RXbufer, 27+2000, &readen, &osRead)) 
			{
                if (GetLastError() == ERROR_IO_PENDING) 
				{
                    // Tu OS ak na naplnenie 27 znakov alebo timeout
                    WaitForSingleObject(osRead.hEvent, 1000); 
                    GetOverlappedResult(ComHandle, &osRead, &readen, FALSE);
                }
                // Vyist zaseknut buffer
                PurgeComm(ComHandle, PURGE_RXABORT | PURGE_RXCLEAR); 
            }

            // 3. Ak sme nieo prijali, poleme to spracova
            if (readen > 0) 
			{
                RXbufer[readen] = '\0'; // Ukonenie reazca pre istotu
                SendMessage(g_hwndDlg, WM_RXCHAR, (WPARAM)readen, 0);
            }
        }
        // Tmto vymaete prznaky chb ako CE_FRAME, CE_OVERRUN at.
		ClearCommError(ComHandle, &dwError, &cs);
    	//spomaluje cyklus while, ked zatial neprisli ziadne znaky
//		if ((pocet_znakov = (int)cs.cbInQue) == 0)
//			Sleep(1);
		if (dwError > 0) 			
			PurgeComm(ComHandle, PURGE_RXABORT | PURGE_RXCLEAR); // Vyist zaseknut buffer
        ResetEvent(osWait.hEvent);
    }
    return 0;
}
//*/






//Procedura edit boxu pre vysielanie. Zabezpeci, aby sa dalo posielat stlacanim ENTER. 
//UM_KEY_IN_CONTROL - uzivatelsky definovana sprava.
LRESULT CALLBACK WindowProcEdit(HWND hwndDlg, UINT Message, WPARAM wParam, LPARAM lParam)
{   switch (Message)
    {   case WM_GETDLGCODE:
             return DLGC_WANTALLKEYS;
        case WM_KEYDOWN:
             SendMessage(GetParent(hwndDlg), UM_KEY_IN_CONTROL, wParam /*kod klvesy*/, (LPARAM)GetMenu(hwndDlg));
             break;
    }
    return CallWindowProc(g_oldProc, hwndDlg, Message, wParam, lParam);        
}    



LRESULT CALLBACK WindowProcEditN(HWND hwndDlg, UINT Message, WPARAM wParam, LPARAM lParam)
{   switch (Message)
    {   case WM_GETDLGCODE:
             return DLGC_WANTALLKEYS;
        case WM_KEYDOWN:
             SendMessage(GetParent(hwndDlg), UM_KEY_IN_CONTROL, wParam /*kod klvesy*/, (LPARAM)GetMenu(hwndDlg));
             break;
    }
    return CallWindowProc(g_oldProc, hwndDlg, Message, wParam, lParam);        
}    









INT_PTR CALLBACK ProceduraDialogu(HWND hwndDlg, UINT Message, WPARAM wParam, LPARAM lParam)
{   RECT rect_indikator;
	HFONT hfEdit, hfButton;
	LOGFONT logFont;
	COLORREF Farba_aktivneho_editboxu = RGB(255,255,255),
			 Farba_NEaktivneho_editboxu = RGB(220,230,240);
	int f,
	//LED psik
	Led_X = 12, 
	Led_Y = 11, 
	Led_CX = 67,
	Led_CY = 6,
	LedZaoblenie = 3;
	
	//Nastavenie rect struktury Led indikatora udajmi o rozmeroch
	SetRect(&rect_indikator, Led_X, Led_Y, Led_X+Led_CX, Led_Y+Led_CY);
	
	//spracovanie sprav adresovanych oknu
    switch(Message)
    {   
		// inicialiyacne udalosti pri otvoreni okna
		case WM_INITDIALOG:
        {   //Spristupnenie rukovate hlavneho dialogoveho okna na globalnej urovni.
			g_hwndDlg = hwndDlg;
			//Vytvorenie timeru pre spravu WM_TIMER
			SetTimer(hwndDlg, _Casovac1, _Cas_1, NULL); 
			//Natanie nastaven z registrov
			ReadRegistry(hwndDlg);	
					
			//Nastavenie polohy a rozmerov hlavneho dialogoveho okna
			SetWindowPos(hwndDlg, 
					/*HWND_TOP*/HWND_TOPMOST, 
					LOWORD(g_dwWindowPos), HIWORD(g_dwWindowPos), 
					//_SirkaHlOkna, _VyskaHlOkna, 
					LOWORD(g_dwWindowSize), HIWORD(g_dwWindowSize),
					SWP_DRAWFRAME);	
			
			//================================ VYTVORENIE POZADIA OKNA PRE PAMčOV BITMAPU ==============================================
			
			// 1. Zskanie intancie aplikcie (ak ju nemte v globlnej premennej)
		    HINSTANCE hInst = GetModuleHandle(NULL);
		    // 2. Natanie bitmapy zo zdrojov poda jej ID
		    HBITMAP hBitmap = (HBITMAP)LoadImage(
		        hInst, 
		        MAKEINTRESOURCE(IDB_BITMAPDLG), // ID definovan v resource.h
		        IMAGE_BITMAP, 
		        0, 0,                           // 0 znamen poui pvodn vekos obrzka
		        LR_DEFAULTCOLOR                 // iadne pecilne prznaky pre sbory
		    );
		    // 3. Vytvorenie tetca s opakujcim sa vzorom
		    if (hBitmap) 
			{	hTexturaBrush = CreatePatternBrush(hBitmap);
		        DeleteObject(hBitmap); // GDI objekt bitmapy meme uvoni, tetec si ho skoproval
		    }
			
			//============================= VYTVORENIE FARBY PRE EDITBOX V MDE "IBA NA TANIE" ==========================================
			
			// Vytvorme ed tetec (RGB 192, 192, 192 je klasick strieborno-ed)
    		hSedyStetec = CreateSolidBrush(Farba_NEaktivneho_editboxu);
    
			//============================================ VYTVORENIE FONTU ==============================================================
			
			hFont = CreateFont(
		        24,                        // Vka (v pixeloch)
		        0,                         // rka (0 = automaticky poda vky)
		        0, 0,                      // Uhly nklonu
		        FW_BOLD,                   // Hrbka (napr. FW_NORMAL, FW_BOLD)
		        FALSE, FALSE, FALSE,       // Kurzva, podiarknutie, preiarknutie
		        DEFAULT_CHARSET,           
		        OUT_OUTLINE_PRECIS, 
		        CLIP_DEFAULT_PRECIS, 
		        CLEARTYPE_QUALITY,         // Kvalita (ClearType vyzer najlepie)
		        VARIABLE_PITCH, 
		        "Segoe UI");               // Nzov psma
		    	
			//========================== VYTVORENIE PROCEDR PRE ODENTROVANIE V EDITBOXOCH ZADVANIA ==============================================================
			
			//Vytvorenie procedury pre editbox, v ktorej sa obsuhuje stlacanie klaves. (aby okienko reagovalo na stlacenie klavesy Enter)
			g_oldProc = (WNDPROC)SetWindowLong(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), GWL_WNDPROC, (LONG_PTR)WindowProcEdit);
			g_oldProc = (WNDPROC)SetWindowLong(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), GWL_WNDPROC, (LONG_PTR)WindowProcEditN);
		
			//========================== ZMENA IKONY, KURZORA, VLASTNOST OKNA, PSMA PRVKOV OKNA  ==============================================================
			
			//nastavenie pozadia, kurzora, ikony, tiea.
//			g_pozadieDlg = CreatePatternBrush(LoadBitmap(g_hInstance, MAKEINTRESOURCE(IDB_BITMAPDLG)));
			SetClassLong(hwndDlg, GCL_HCURSOR,(LONG_PTR)LoadCursor(g_hInstance, MAKEINTRESOURCE(IDC_CURSOR)));
			SetClassLong(GetDlgItem(hwndDlg, ID_COMBO_BAUDRATE), GCL_HCURSOR,(LONG_PTR)LoadCursor(g_hInstance, MAKEINTRESOURCE(IDC_CURSOR2)));
			SetClassLong(GetDlgItem(hwndDlg, ID_BUTTON_DISCONNECT), GCL_HCURSOR,(LONG_PTR)LoadCursor(g_hInstance, MAKEINTRESOURCE(IDC_CURSOR2)));
			SetClassLong(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), GCL_HCURSOR,(LONG_PTR)LoadCursor(g_hInstance, MAKEINTRESOURCE(IDC_CURSOR3)));
			SetClassLong(hwndDlg, GCL_HICONSM,(LONG_PTR)LoadIcon(g_hInstance, MAKEINTRESOURCE(IDI_ICON)));  
			//SetClassLong(hwndDlg, GCL_STYLE,(LONG_PTR)CS_DROPSHADOW);      
			//SetWindowLong(hwndDlg, GWL_EXSTYLE,(LONG_PTR)WS_EX_CLIENTEDGE); 
			
			//Nastavenie fontu EditBoxov
			GetObject(GetStockObject(DEFAULT_GUI_FONT), sizeof(logFont), &logFont);
			lstrcpy(logFont.lfFaceName, TEXT("Segoe UI"));
			logFont.lfHeight = -16;
			logFont.lfWeight = 0;	
			hfEdit = CreateFontIndirect(&logFont);
			SendDlgItemMessage(hwndDlg, ID_EDIT_TX_ASCII, WM_SETFONT, (WPARAM)hfEdit, (LPARAM)TRUE);  
			SendDlgItemMessage(hwndDlg, ID_EDIT_TX_NUMBER, WM_SETFONT, (WPARAM)hfEdit, (LPARAM)TRUE);  
			SendDlgItemMessage(hwndDlg, ID_EDIT_TX_HISTORY, WM_SETFONT, (WPARAM)hfEdit, (LPARAM)TRUE); 
			SendDlgItemMessage(hwndDlg, ID_EDIT_RX_HISTORY, WM_SETFONT, (WPARAM)hfEdit, (LPARAM)TRUE); 
			
			//Nastavenie fontU Tlatiek	
			//(logFont.lfFaceName, TEXT("MS Sans Serif"));
			lstrcpy(logFont.lfFaceName, TEXT("Segoe UI"));
			logFont.lfHeight = -12;
			logFont.lfWeight = 600;		 
			hfButton = CreateFontIndirect(&logFont);
			SendDlgItemMessage(hwndDlg, ID_BUTTON_DISCONNECT, WM_SETFONT, (WPARAM)hfButton, (LPARAM)TRUE);  
			
			//================================ VCHODZIE NASTAVENIE COM PORTU ===============================================
			
			//defaultne zaskrknutie radiobuttonov nastavenia COMportu (DCB struktury)
			CheckRadioButton(hwndDlg, ID_RADIO_DATABITY_5, ID_RADIO_DATABITY_8, ID_RADIO_DATABITY_8);	//Data bity
			CheckRadioButton(hwndDlg, ID_RADIO_BEZ_PARITY, ID_RADIO_NULOVA_PARITA, ID_RADIO_BEZ_PARITY);//Parita
			CheckRadioButton(hwndDlg, ID_RADIO_STOPBIT_1, ID_RADIO_STOPBIT_2, ID_RADIO_STOPBIT_1);		//Stop bity
			CheckRadioButton(hwndDlg, ID_RADIO_ASCII, ID_RADIO_NUMBER, ID_RADIO_ASCII);					//Reim zadvania
			//Skryje tlacitko ODPOJIT (zatial totiz este nie je otvoreny ziadny COMport)
	        ShowWindow(GetDlgItem(hwndDlg, ID_BUTTON_DISCONNECT), SW_HIDE);
	        //Deaktivuje tlacitko DCB (zatial totiz este nie je otvoreny ziadny COMport)
			EnableWindow(GetDlgItem(hwndDlg, ID_BUTTON_DCB), FALSE);	
			//Zobraz bu okienko zadvanvia ASCII alebo sel, poda zakrtnutho vberu
			if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
	 		{	ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), SW_HIDE);
	 			ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), SW_SHOW);	
	 			//TX okienko zadavania textu len na tanie (zatial totiz este nie je otvoreny ziadny COMport)
	 			SendMessage(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), EM_SETREADONLY, TRUE, 0);		       			
	 		} 		
	 		//Nastavi fokus TX Edit riadku pre zadavanie cisel, ak je zaskrknute Cisla
			if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
	 		{	ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), SW_HIDE);
	 			ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), SW_SHOW);	 
	 			//TX okienko zadavania cissel len na tanie (zatial totiz este nie je otvoreny ziadny COMport)
	 			SendMessage(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), EM_SETREADONLY, TRUE, 0);
	 		}	 		
	 	
	    	//Aktualizuje COM porty. Ak nejak existuj, aktivuje tlatko pripoji. Inak bude deaktivovan
			if(Hladanie_com_portov(hwndDlg))
         	{	EnableWindow(GetDlgItem(hwndDlg, ID_BUTTON_CONNECT), TRUE);		
         		AktivaciaRadioButtonov(hwndDlg);	
         	}
         	else
         	{	EnableWindow(GetDlgItem(hwndDlg, ID_BUTTON_CONNECT), FALSE);		
         		DeaktivaciaRadioButtonov(hwndDlg);
         	}
			/*
			// Defincia vetkch podporovanch rchlost pre ComboBox
			static const TCHAR* Rychlosti[] = { 
			    TEXT("75"), TEXT("110"), TEXT("150"), TEXT("300"), TEXT("600"), 
			    TEXT("1200"), TEXT("1800"), TEXT("2400"), TEXT("4800"), TEXT("7200"), TEXT("9600"), 
			    TEXT("14400"), TEXT("19200"), TEXT("38400"), TEXT("57600"), 
			    TEXT("115200"), TEXT("128000"), TEXT("256000") 
			};
			//Naplnenie comboboxu rhlosami komunikacie. 
			for (f = 0; f < sizeof(Rychlosti) / sizeof(Rychlosti[0]); f++) 
			    SendDlgItemMessage(hwndDlg, ID_COMBO_BAUDRATE, CB_ADDSTRING, 0, (LPARAM)Rychlosti[f]);
			//*/
			//*
			// Defincia vetkch podporovanch rchlost pre ComboBox (Varianta 2)
			static const DWORD nRychlosti[] = { 75, 110, 150, 300, 600, 1200, 1800, 2400, 4800, 7200, 9600, 
												14400, 19200, 38400, 57600, 115200, 128000, 256000 };
			TCHAR buffer[20];
			//Naplnenie comboboxu rhlosami komunikacie s premenou sel na textov reazec
			for (f = 0; f < sizeof(nRychlosti) / sizeof(nRychlosti[0]); f++) 
			{
			    wsprintf(buffer, TEXT(" %d"), nRychlosti[f]); // Prevod sla na text
			    SendDlgItemMessage(hwndDlg, ID_COMBO_BAUDRATE, CB_ADDSTRING, 0, (LPARAM)buffer);
			}
			//Zvolenie aktualnej polozky rychlosti
			SendDlgItemMessage(hwndDlg, ID_COMBO_BAUDRATE, CB_SETCURSEL, Aktualna_rychlost, 0);
			//Ak bol uzivatel pripojeny k najvyssiemu portu a po zatvoreni programu bol odpojeny, 
			//pri dalsom otvoreni programu zvol nultu poziciu Comboboxu volby portov.
			if(posledny_pripojeny_port == pocet_portov_pre_ComboBox)
				if((Hladanie_com_portov(hwndDlg) - 1) < pocet_portov_pre_ComboBox)
					posledny_pripojeny_port = 0;
			//Zvolenie aktualnej polozky vyberu portu z registrov.
			SendDlgItemMessage(hwndDlg, ID_COMBO_PORT_SELECT, CB_SETCURSEL, posledny_pripojeny_port, 0);
	        
	        
	        
	        
	        
	        
	        
	        
	        HBITMAP hBitmap2 = (HBITMAP)LoadImage(
		        hInst, 
		        MAKEINTRESOURCE(IDB_OBRAZOK), // ID definovan v resource.h
		        IMAGE_BITMAP, 
		        0, 0,                           // 0 znamen poui pvodn vekos obrzka
		        LR_DEFAULTCOLOR                 // iadne pecilne prznaky pre sbory
		    );
	        
	        
	        
	        
	        
            return TRUE;
        }   
        
        
            
        // Povieme: "Ja som pozadie vymazal sm", aj ke sme ni nespravili.
		case WM_ERASEBKGND:
		    return 1; 
		
        
        
        //Pozadie dialogoveho okna
        case WM_CTLCOLORDLG:
        {    SetBkMode((HDC)wParam, TRANSPARENT);
             return (INT_PTR)hTexturaBrush;
        }  
	
		
		
		// Pozadie a farby prvkov
		//case WM_CTLCOLORLISTBOX:
		case WM_CTLCOLORSTATIC:
		
		case WM_CTLCOLOREDIT:
		{
		    HDC hdc = (HDC)wParam;
		    HWND hwndCtrl = (HWND)lParam;
		    int ctrlID = GetDlgCtrlID(hwndCtrl);
		    LONG style;	
		    // 1. pecifick Edit Boxy (farba poda stavu)
			if (ctrlID == ID_EDIT_TX_HISTORY || ctrlID == ID_EDIT_RX_HISTORY || ctrlID == ID_EDIT_TX_ASCII || ctrlID == ID_EDIT_TX_NUMBER)
		    {	style = GetWindowLong(hwndCtrl, GWL_STYLE);
		        if (style & ES_READONLY) 
		        {	SetBkColor(hdc, Farba_NEaktivneho_editboxu);
		        	SetTextColor(hdc, RGB(0, 0, 0));
		            return (INT_PTR)hSedyStetec;
		        } 
		        else 
		        {	SetBkColor(hdc, Farba_aktivneho_editboxu);
		            return (INT_PTR)GetStockObject(WHITE_BRUSH);
		        }
		    } 
		    //Zabezpeenie, aby pozadie okna splvalo s pozadm radiobuttonov (aby si nevykresovali textru pozadia samostatne).
		    if (ctrlID == ID_RADIO_STOPBIT_1 || ctrlID == ID_RADIO_STOPBIT_1_5 || ctrlID == ID_RADIO_STOPBIT_2 ||
				ctrlID == ID_RADIO_DATABITY_5 || ctrlID == ID_RADIO_DATABITY_6 || ctrlID == ID_RADIO_DATABITY_7 || 
				ctrlID == ID_RADIO_DATABITY_8 || ctrlID == ID_RADIO_BEZ_PARITY || ctrlID == ID_RADIO_NEPARNA_PARITA ||
				ctrlID == ID_RADIO_PARNA_PARITA || ctrlID == ID_RADIO_JEDNOTKOVA_PARITA || ctrlID == ID_RADIO_NULOVA_PARITA ||
				ctrlID == ID_RADIO_ASCII || ctrlID == ID_RADIO_NUMBER ||
				ctrlID == IDC_STATIC1 || ctrlID == IDC_STATIC3 || ctrlID == IDC_STATIC4 || ctrlID == IDC_STATIC5 || 
				ctrlID == IDC_STATIC6 || ctrlID == IDC_STATIC7) 
			{
		        SetBkMode(hdc, TRANSPARENT);
		        // 1. Zistme pozciu prvku voi hlavnmu oknu
		        RECT rc;
		        // Sradnice obrazovky
		        GetWindowRect(hwndCtrl, &rc); 
		        // Konverzia na sradnice okna
		        ScreenToClient(hwndDlg, (LPPOINT)&rc.left); 
		        ScreenToClient(hwndDlg, (LPPOINT)&rc.right);
		        // 2. Posunieme pvod kreslenia tetca na sradnice prvku
		        // To zabezpe, e textra pod prvkom presne nadviae na pozadie
		        SetBrushOrgEx(hdc, -rc.left, -rc.top, NULL);
		        return (INT_PTR)hTexturaBrush;
			}
		    // 2. Vetko ostatn (Radio Buttony, Group Boxy, Labels)
		    // Aby boli na textre neviditen aj v XP vzhade:
		    SetBkMode(hdc, TRANSPARENT);
		    // Synchronizcia kreslenia tetca
		    SetBrushOrgEx(hdc, 0, 0, NULL); 
		    // Musme vrti fyzick tetec s textrou
		    return (INT_PTR)hTexturaBrush;  
		}		
				
		
		
		
		
		
		// Uvatesky vykresovan prvky okna.
		case WM_DRAWITEM:
		{	LPDRAWITEMSTRUCT pdis = (LPDRAWITEMSTRUCT)lParam;

			// 1. ROZL͊ENIE PODA TYPU PRVKU (CtlType)
			if (pdis->CtlType == ODT_BUTTON) 
			{	/*
				COLORREF 	Farba = RGB(0, 120, 215),		// Farba tlatka
							Farba_okraja = RGB(0, 22, 40),//RGB(0, 45, 80),	//Farba okraja tlatka
							Farba_stlaceneho = RGB(0, 90, 160),		// Farba stlaenho tlatka
							Farba_pisma = RGB(255, 255, 255);	// Farba psma
							//*/
				COLORREF 	//Farba = RGB(178, 224, 249),		// Farba tlatka
							Farba = RGB(228, 244, 252),		// Farba tlatka
							Farba_okraja = RGB(57, 61, 63),//RGB(0, 45, 80),	//Farba okraja tlatka
							Farba_stlaceneho = RGB(182, 195, 202),		// Farba stlaenho tlatka
							Farba_pisma = RGB(0, 0, 0);	// Farba psma
				
				Vlastne_Tlacitko(lParam, ID_BUTTON_CONNECT, Farba, Farba_okraja, Farba_stlaceneho, Farba_pisma);
				Vlastne_Tlacitko(lParam, ID_BUTTON_DISCONNECT, RGB(70, 255, 70), RGB(0, 100, 0), RGB(50, 200, 50), Farba_pisma);
				Vlastne_Tlacitko(lParam, ID_BUTTON_REFRESH, Farba, Farba_okraja, Farba_stlaceneho, Farba_pisma);
				Vlastne_Tlacitko(lParam, ID_BUTTON_DCB, Farba, Farba_okraja, Farba_stlaceneho, Farba_pisma);
				Vlastne_Tlacitko(lParam, ID_BUTTON_CLEAR_TX, Farba, Farba_okraja, Farba_stlaceneho, Farba_pisma);
				Vlastne_Tlacitko(lParam, ID_BUTTON_CLEAR_RX, Farba, Farba_okraja, Farba_stlaceneho, Farba_pisma);
				Vlastne_Tlacitko(lParam, IDCANCEL, Farba, Farba_okraja, Farba_stlaceneho, Farba_pisma);
			
			
			}
			else if (pdis->CtlType == ODT_COMBOBOX)
			{	/*
				 COLORREF 	Farba = RGB(0, 120, 215),		// Farba Comboboxu
							Farba_okraja = RGB(0, 255, 0),	//RGB(0, 45, 80),	//Farba okraja Comboboxu
							Farba_pisma = RGB(255, 255, 255),	// Farba psma Comboboxu
							Farba_vyberu = RGB(255, 255, 0),		// Farba Comboboxu
							Farba_okraja_vyberu = RGB(0, 0, 0),	//RGB(0, 45, 80),	//Farba okraja Comboboxu
							Farba_pisma_vyberu = RGB(0, 0, 0);	// Farba psma Comboboxu
							//*/
							
				COLORREF 	Farba = RGB(150, 220, 255),		// Farba Comboboxu
							Farba_okraja = RGB(255, 255, 255),	//RGB(0, 45, 80),	//Farba okraja Comboboxu
							Farba_pisma = RGB(0, 0, 0),	// Farba psma Comboboxu
							Farba_vyberu = RGB(0, 120, 215),		// Farba Comboboxu
							Farba_okraja_vyberu = RGB(255, 255, 255),	//RGB(0, 45, 80),	//Farba okraja Comboboxu
							Farba_pisma_vyberu = RGB(255, 255, 255);	// Farba psma Comboboxu
							
				Vlastny_ComboBox(lParam, Farba, Farba_okraja, Farba_pisma, Farba_vyberu, Farba_okraja_vyberu, Farba_pisma_vyberu);
			}
			


			
			
			
			 
			 return TRUE;
		    
		}
		
		
		
		
		
		  
		
		case WM_RXCHAR:
		{	//Skoprovanie textu z prijmacieho bufra do pracovnho poa
         	if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
               lstrcpy(textRX, RXbufer);
            //Skoprovanie sla z prijmacieho bufra do pracovnho poa
         	if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
               _stprintf(textRX, "%d", (unsigned TCHAR)RXbufer[0]);		//premena znaku na cislo
            //Vlozi znak odriadkovania pre editbox
            lstrcat(textRX, g_novyRiadok);
//            lstrcat(textRX, " ");
			// vlozi prijat text/slo do editboxu histrie RX
			SendDlgItemMessage(hwndDlg, ID_EDIT_RX_HISTORY, EM_REPLACESEL, FALSE, (LPARAM)textRX);
	 		break;
		}
		
		
		
//ooo		
		//uzivatelsky definovana sprava poslana z procedury editboxov. ... 
        //...Vo svojom wParam-etri obsahuje kod stlacenej klavesy a v lParam-etri...
        //...identifikator vybraneho editboxu. 
        case UM_KEY_IN_CONTROL:
        {   
			switch (lParam) //v lParam je zatial identifikator len jedneho editboxu - konkretne zadavacieho okienka
             {   case ID_EDIT_TX_ASCII:
             	 case ID_EDIT_TX_NUMBER:
                 //po stlaceni ENTER sa text skopiruje zo zadavacieho okienka do textoveho editboxu.     
                 if (wParam == VK_RETURN)
                 {   
				 	//Dynamick prideovanie pamte poda dky odosielanho textu
				    int Dlzka_textu = SendDlgItemMessage(hwndDlg, lParam, WM_GETTEXTLENGTH, 0, 0);
				    TCHAR *textTX = (TCHAR*) calloc(Dlzka_textu + 5, sizeof(TCHAR));
				 
				 	//ziska text zo zadavacieho okienka, ak je zaskrknuty radiobutton "ASCII"
                 	if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
                    {	GetDlgItemText(hwndDlg, lParam, textTX, Dlzka_textu+5);
                    	lstrcpy(TXbufer, textTX);
                    }
                    //ziska text zo zadavacieho okienka a prevedie ho na celociselnu hodnotu, ak je zaskrknuty radiobutton "Cisla"
                 	if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
                    {	ciselna_hodnota = GetDlgItemInt(hwndDlg, lParam, NULL, FALSE);
                    	_stprintf(TXbufer, "%c", ciselna_hodnota);
                    	_stprintf(textTX, TEXT("%d"), ciselna_hodnota);
                    }
                     
                     
                    //vytvorenie udalosti do OVERLAPPED struktury
                    osWrite.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
                    //odoslanie textu na port
                    if(!WriteFile(ComHandle, TXbufer, lstrlen(TXbufer), NULL, &osWrite))
                    {	 //pridanie odriadkovania
//						 lstrcat(textTX, g_novyRiadok); 
						 lstrcat(textTX, " "); 
	                    //Zmeria pocet znakov z okienka zadania. V prpade nenulovho vsledku, vlozi text do okienka historie TX.
	                    if(Dlzka_textu)
	                    {	//vlozi zadany text do editboxu histrie TX
							SendDlgItemMessage(hwndDlg, ID_EDIT_TX_HISTORY, EM_REPLACESEL, FALSE, (LPARAM)textTX);
							//_stprintf(textRX, TEXT("%d "), Dlzka_textu);
							//SendDlgItemMessage(hwndDlg, ID_EDIT_RX_HISTORY, EM_REPLACESEL, FALSE, (LPARAM)textRX);
						}
						//vymaze aktualny text v okienku zadania
        	            SendDlgItemMessage(hwndDlg, lParam, WM_SETTEXT, 0, 0); 	
        	            
        	            
						
	                }
	                //Uzatvorenie handle udalosti
	                CloseHandle(osWrite.hEvent);
	                free(textTX);
                 }
                 break;
             }
             return TRUE;       
    	}
    	
    	

		

 
		 case WM_TIMER:
        {   switch(wParam)
			{	case _Casovac1: 
				{	//Aktualizuje COM porty v asovch intervaloch
					if(Hladanie_com_portov(hwndDlg))
	             	{	//Aktivizuje tlacitko PRIPOJIT
					 	EnableWindow(GetDlgItem(hwndDlg, ID_BUTTON_CONNECT), TRUE);		
	             		AktivaciaRadioButtonov(hwndDlg);	
	             	}
	             	else
	             	{	//Deaktivizuje tlacitko PRIPOJIT
					 	EnableWindow(GetDlgItem(hwndDlg, ID_BUTTON_CONNECT), FALSE);		
	             		DeaktivaciaRadioButtonov(hwndDlg);
	             	}
	             	//Beep (800, 60);			  	  	
				}
				break;
			}
			break;
        }      	
		
		
		
		
        case WM_COMMAND:
        {     
			 switch(LOWORD(wParam))
             {  	            
				//========================================== TLATKA =================================================================  
				      
				//Tlacitko PRIPOJIT RS232
             	case ID_BUTTON_CONNECT:
             	{   KillTimer(hwndDlg, _Casovac1);    	
  					// Nacita zvoleny port
             		zvoleny_port = AktivnePorty[(BYTE)SendDlgItemMessage(hwndDlg, ID_COMBO_PORT_SELECT, CB_GETCURSEL, 0, 0)];
             		//otvori zvoleny port
					if(zvoleny_port)	 
						StavPripojeniaCOM = OpenCom(hwndDlg, zvoleny_port);	
					// VYTVORENIE VLAKNA
					if(StavPripojeniaCOM)
						ghThread = CreateThread(NULL, 0, ThreadProc, NULL, 0, 0); 
					// Deaktivcia/Aktivcia prslunch prvkov okna v prpade spenho pripojenia
             		if(StavPripojeniaCOM)
	             	{	ShowWindow(GetDlgItem(hwndDlg, ID_BUTTON_CONNECT), SW_HIDE);	//Skryje tlacitko PRIPOJIT
             			ShowWindow(GetDlgItem(hwndDlg, ID_BUTTON_DISCONNECT), SW_SHOW);	//Zobrazi tlacitko ODPOJIT
             			EnableWindow(GetDlgItem(hwndDlg, ID_COMBO_PORT_SELECT), FALSE);	//Deaktivuje volbu portu
             			EnableWindow(GetDlgItem(hwndDlg, ID_BUTTON_DCB), TRUE);	
						//Aktivcia a zobrazenie prslunho TX Edit riadku ASCII/NUMBER poda nastavenia
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
				 		{	ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), SW_HIDE);
				 			ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), SW_SHOW);	
				 			SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII));
				 			//TX okienko zadavania textu sa aktivuje aj pre psanie
				 			SendMessage(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), EM_SETREADONLY, FALSE, 0);		       			
				 		} 		
				 		//Nastavi fokus TX Edit riadku pre zadavanie cisel, ak je zaskrknute Cisla
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
				 		{	ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), SW_HIDE);
				 			ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), SW_SHOW);
							SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER));	 
				 			//TX okienko zadavania sla sa aktivuje aj pre psanie
				 			SendMessage(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), EM_SETREADONLY, FALSE, 0);
				 		}
             		}
             		else
             		{	EnableWindow(GetDlgItem(hwndDlg, ID_BUTTON_CONNECT), FALSE);	//Deaktivuje tlacitko PRIPOJIT
             			EnableWindow(GetDlgItem(hwndDlg, ID_BUTTON_DCB), FALSE);	
             		}
				    // Prekreslenie oblasti okna, kde je "LED indikator" pripojenia	
                    RedrawWindow(hwndDlg, &rect_indikator, NULL, RDW_UPDATENOW | RDW_INVALIDATE);  	
                    RedrawWindow(hwndDlg, NULL, NULL, RDW_UPDATENOW | RDW_INVALIDATE);  	
             		break;
             	}   
             	
             	
             	
             	//Tlacitko ODPOJIT
             	case ID_BUTTON_DISCONNECT:
             	{	StavPripojeniaCOM = 0; 					 
					//Zatvorenie portu
					CloseCom();
             		ShowWindow(GetDlgItem(hwndDlg, ID_BUTTON_DISCONNECT), SW_HIDE);	//Skryje tlacitko ODPOJIT
	            	ShowWindow(GetDlgItem(hwndDlg, ID_BUTTON_CONNECT), SW_SHOW);	//Zobrazi tlacitko PRIPOJIT
	            	EnableWindow(GetDlgItem(hwndDlg, ID_COMBO_PORT_SELECT), TRUE);		//Aktivuje volbu portu
	            	EnableWindow(GetDlgItem(hwndDlg, ID_BUTTON_DCB), FALSE);
					
					//Nastavi fokus TX Edit riadku pre zadavanie textu, ak je zaskrknute ASCII
					if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
			 		{	ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), SW_HIDE);
			 			ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), SW_SHOW);	
			 			//TX okienko zadavania textu len na tanie (zatial totiz este nie je otvoreny ziadny COMport)
			 			SendMessage(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), EM_SETREADONLY, TRUE, 0);		       			
			 		} 		
			 		//Nastavi fokus TX Edit riadku pre zadavanie cisel, ak je zaskrknute Cisla
					if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
			 		{	ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), SW_HIDE);
			 			ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), SW_SHOW);	 
			 			//TX okienko zadavania cissel len na tanie (zatial totiz este nie je otvoreny ziadny COMport)
			 			SendMessage(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), EM_SETREADONLY, TRUE, 0);
			 		}

            		SetTimer(hwndDlg, _Casovac1, _Cas_1, NULL); 
					// Prekreslenie oblasti okna, kde je "LED indikator" pripojenia
                    RedrawWindow(hwndDlg, &rect_indikator, NULL, RDW_UPDATENOW | RDW_INVALIDATE);
             		break;
             	}
	             
	             
	                   	
             	//Tlacitko OBNOVIT
             	case ID_BUTTON_REFRESH:
             	{	
					if(StavPripojeniaCOM == 1)
                     {  //Nastavenie fokusu do yad=avacieho okienka
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
				 			SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII));
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
							SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER));	 
                	 }		
             		break;
             	}
             	
             	
	             
            	//Tlacitko DCB
             	case ID_BUTTON_DCB:
             	{	if(StavPripojeniaCOM == 1)
                     {  //Nastavenie fokusu do yad=avacieho okienka
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
				 			SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII));
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
							SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER));	 
                	 }
				 	//Test nastavenia DCB
             		//if((StavPripojeniaCOM == 1) && (Pocet_existujucich_portov > 0))
					{	//Ziska nastavene hodnotzy DCB struktury priamo z PC, a zobrazi ich v MessageBoxe. 
						if(GetCommState(ComHandle, &dcb2))
						{	_stprintf(TestDCB,
									"DCBlength	  %d\n"
									"BaudRate	  %d\n"
									"fBinary		  %d\n"
									"fParity		  %d\n"
									"fOutxCtsFlow	  %d\n"
									"fOutxDsrFlow	  %d\n"
									"fDtrControl	  %d\n"
									"fDsrSensitivity	  %d\n"
									"fTXContinueOnXoff  %d\n"
									"fOutX		  %d\n"
									"fInX		  %d\n"
									"fErrorChar	  %d\n"
									"fNull		  %d\n"
									"fRtsControl	  %d\n"
									"fAbortOnError	  %d\n"
									"fDummy2	  %d\n"
									"wReserved	  %d\n"
									"XonLim		  %d\n"
									"XoffLim		  %d\n"
									"ByteSize		  %d\n"
									"Parity		  %d\n"
									"StopBits		  %d\n"
									"XonChar		  %d\n"
									"XoffChar		  %d\n"
									"ErrorChar		  %d\n"
									"EofChar		  %d\n"
									"EvtChar		  %d\n"
									"wReserved1	  %d",
									dcb2.DCBlength,
									dcb2.BaudRate,
									dcb2.fBinary,
									dcb2.fParity,
									dcb2.fOutxCtsFlow,
									dcb2.fOutxDsrFlow,
									dcb2.fDtrControl,	
									dcb2.fDsrSensitivity,
									dcb2.fTXContinueOnXoff,
									dcb2.fOutX,
									dcb2.fInX,
									dcb2.fErrorChar,
									dcb2.fNull,
									dcb2.fRtsControl,
									dcb2.fAbortOnError,
									dcb2.fDummy2,
									dcb2.wReserved,
									dcb2.XonLim,
									dcb2.XoffLim,
									dcb2.ByteSize,
									dcb2.Parity,
									dcb2.StopBits,
									dcb2.XonChar,
									dcb2.XoffChar,
									dcb2.ErrorChar,
									dcb2.EofChar,
									dcb2.EvtChar,
									dcb2.wReserved1);
							MessageBox(hwndDlg, TestDCB, "DCB truktra", MB_OK | MB_ICONINFORMATION);
						}
						else	
							MessageBox(hwndDlg, "Nebolo mon zska nastavenia DCB truktry.", "Chyba", MB_OK | MB_ICONINFORMATION);
					}
             		break;
             	}
             	
          	
             	
             	//Tlacitko vymazat historiu TX
                 case ID_BUTTON_CLEAR_TX:
                 {	 //vymaze aktualny text v textovom okienku TX
                     SendDlgItemMessage(hwndDlg, ID_EDIT_TX_HISTORY, WM_SETTEXT, 0, 0); 
                     if(StavPripojeniaCOM == 1)
                     {  //Nastavenie fokusu do yad=avacieho okienka
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
				 			SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII));
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
							SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER));	 
                	 }
                    RedrawWindow(hwndDlg, NULL, NULL, RDW_UPDATENOW | RDW_INVALIDATE);
                 	break;
                 }
                 
                 //Tlacitko vymazat historiu RX
                 case ID_BUTTON_CLEAR_RX:
                 {
                 	//vymaze aktualny text v textovych okienkach RX
					SendDlgItemMessage(hwndDlg, ID_EDIT_RX_HISTORY, WM_SETTEXT, 0, 0);
					if(StavPripojeniaCOM == 1)
                     {  //Nastavenie fokusu do yad=avacieho okienka
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
				 			SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII));
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
							SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER));	 
                	 }
         			RedrawWindow(hwndDlg, NULL, NULL, RDW_UPDATENOW | RDW_INVALIDATE);
                 	break;
                 }             	
      
//=========================================================== COMBOBOXY =================================================================
  	        
				//Volba bitovej rychlosti
	         	case ID_COMBO_BAUDRATE:
	         	{	if(StavPripojeniaCOM == 1)
						Nastavenie_DCB_struktury(hwndDlg);
					//Uvate si vybral poloku		
					if (HIWORD(wParam) == CBN_SELCHANGE)
					{	//Nastavenie fokusu do zadvacieho okienka
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
				 			SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII));
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
							SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER)); 
						Aktualna_rychlost = (int)SendDlgItemMessage(hwndDlg, ID_COMBO_BAUDRATE, CB_GETCURSEL, 0, 0);
						WriteRegistry(hwndDlg);		
					}					
	         		break;
	         	}
	         	
	         	case ID_COMBO_PORT_SELECT:
	         	{	//Uvate si vybral poloku		
					if (HIWORD(wParam) == CBN_SELCHANGE)
					{	//Nastavenie fokusu do zadvacieho okienka
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
				 			SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII));
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
							SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER)); 
						posledny_pripojeny_port = (int)SendDlgItemMessage(hwndDlg, ID_COMBO_PORT_SELECT, CB_GETCURSEL, 0, 0);
						WriteRegistry(hwndDlg);		
					}					
	         		break;
	         	}
	         	
	         
      
	             

//================================================= Radiobuttony ASCII/sla =================================================================
                                 
                //RadioButton ACSII
                 case ID_RADIO_ASCII:
                 {	if(StavPripojeniaCOM == 1)
                    {	ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), SW_HIDE);
	 					ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), SW_SHOW);	
						EnableWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), TRUE);
                    	EnableWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), FALSE);
						SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII));
					}
                 	break;
                 }
                 //RadioButton Cisla
                 case ID_RADIO_NUMBER:
                 {	if(StavPripojeniaCOM == 1)
                    { 	ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), SW_HIDE);
	 					ShowWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), SW_SHOW);	
						EnableWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER), TRUE);
                    	EnableWindow(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII), FALSE);
                    	SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER));		//fokus editacneho okienka
                    }
                 	break;
                 }

                 
                 
//================================================= Radiobuttony "Data bity" =================================================================
                               
                 //RadioButton DataBit  5
                 case ID_RADIO_DATABITY_5:
                 {	if(StavPripojeniaCOM == 1)
					{	Nastavenie_DCB_struktury(hwndDlg);
						//Nastavenie fokusu do zadvacieho okienka
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
				 			SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII));
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
							SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER));
					}
                 	EnableWindow(GetDlgItem(hwndDlg, ID_RADIO_STOPBIT_1_5), TRUE); 	// aktivovat 1.5 stopbitu				 
				 	EnableWindow(GetDlgItem(hwndDlg, ID_RADIO_STOPBIT_2), FALSE); 		// deaktivovat 2 stopbity
                 	if(IsDlgButtonChecked(hwndDlg, ID_RADIO_STOPBIT_2) == BST_CHECKED)	//AK je zaskrknuty RadioButton 5 Databitov
            			CheckRadioButton(hwndDlg, ID_RADIO_STOPBIT_1, ID_RADIO_STOPBIT_2, ID_RADIO_STOPBIT_1);  //zaskrknut RadioButton 1 stopbit
					break;
				 }                 
                 //RadioButton DataBit  6
                 case ID_RADIO_DATABITY_6:
                 {	if(StavPripojeniaCOM == 1)
					{	Nastavenie_DCB_struktury(hwndDlg);
						//Nastavenie fokusu do yad=avacieho okienka
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
				 			SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII));
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
							SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER));
					}
				 	EnableWindow(GetDlgItem(hwndDlg, ID_RADIO_STOPBIT_2), TRUE); 	// aktivovat 2 stopbity
                 	EnableWindow(GetDlgItem(hwndDlg, ID_RADIO_STOPBIT_1_5), FALSE); 	// deaktivovat 1.5 stopbitu
                 	if(IsDlgButtonChecked(hwndDlg, ID_RADIO_STOPBIT_1_5) == BST_CHECKED)	//AK je zaskrknuty RadioButton 1.5 stopbitu
            			CheckRadioButton(hwndDlg, ID_RADIO_STOPBIT_1, ID_RADIO_STOPBIT_2, ID_RADIO_STOPBIT_1);  //zaskrknut RadioButton 1 stopbit
                 
					break;
				 }    
				 
				              
                 //RadioButton DataBit  7
                 case ID_RADIO_DATABITY_7:
                 {	if(StavPripojeniaCOM == 1)
					{	Nastavenie_DCB_struktury(hwndDlg);
						//Nastavenie fokusu do yad=avacieho okienka
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
				 			SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII));
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
							SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER));
					}
				 	EnableWindow(GetDlgItem(hwndDlg, ID_RADIO_STOPBIT_2), TRUE); 	// aktivovat 2 stopbity
                 	EnableWindow(GetDlgItem(hwndDlg, ID_RADIO_STOPBIT_1_5), FALSE); 	// deaktivovat 1.5 stopbitu
                 	if(IsDlgButtonChecked(hwndDlg, ID_RADIO_STOPBIT_1_5) == BST_CHECKED)	//AK je zaskrknuty RadioButton 1.5 stopbitu
            			CheckRadioButton(hwndDlg, ID_RADIO_STOPBIT_1, ID_RADIO_STOPBIT_2, ID_RADIO_STOPBIT_1);  //zaskrknut RadioButton 1 stopbit
					break;
				 }  
				 
				                
                 //RadioButton DataBit  8
                 case ID_RADIO_DATABITY_8:
                 {	if(StavPripojeniaCOM == 1)
					{	Nastavenie_DCB_struktury(hwndDlg);
						//Nastavenie fokusu do yad=avacieho okienka
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
				 			SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII));
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
							SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER));
					}
				 	EnableWindow(GetDlgItem(hwndDlg, ID_RADIO_STOPBIT_2), TRUE); 	// aktivovat 2 stopbity
                 	EnableWindow(GetDlgItem(hwndDlg, ID_RADIO_STOPBIT_1_5), FALSE); 	// deaktivovat 1.5 stopbitu
                 	if(IsDlgButtonChecked(hwndDlg, ID_RADIO_STOPBIT_1_5) == BST_CHECKED)	//AK je zaskrknuty RadioButton 1.5 stopbitu
            			CheckRadioButton(hwndDlg, ID_RADIO_STOPBIT_1, ID_RADIO_STOPBIT_2, ID_RADIO_STOPBIT_1);  //zaskrknut RadioButton 1 stopbit
					break;
				 }  
				 
//================================================= Radiobuttony "Parita" =================================================================
 
				case ID_RADIO_BEZ_PARITY:
				case ID_RADIO_NEPARNA_PARITA:
				case ID_RADIO_PARNA_PARITA:
				case ID_RADIO_JEDNOTKOVA_PARITA:
				case ID_RADIO_NULOVA_PARITA:			
//================================================= Radiobuttony "Stopbity" =================================================================
				case ID_RADIO_STOPBIT_1:
				case ID_RADIO_STOPBIT_1_5:
				case ID_RADIO_STOPBIT_2:
				{	if(StavPripojeniaCOM == 1)
					{	Nastavenie_DCB_struktury(hwndDlg);
						//Nastavenie fokusu do yad=avacieho okienka
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_ASCII) == BST_CHECKED)
				 			SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_ASCII));
						if(IsDlgButtonChecked(hwndDlg, ID_RADIO_NUMBER) == BST_CHECKED)
							SetFocus(GetDlgItem(hwndDlg, ID_EDIT_TX_NUMBER));
					}
					break;
				}  
			 
                  
				 case IDCANCEL:
                 {	  pocet_portov_pre_ComboBox = Hladanie_com_portov(hwndDlg) - 1;
				 	  WriteRegistry(hwndDlg);
				 	  DeleteObject(hfEdit);
                 	  DeleteObject(hfButton);
                 	  CloseHandle(ComHandle);
                 	  KillTimer(hwndDlg, 1);
                 	  CloseHandle(osStat.hEvent);
                 	  if (hSedyStetec) 
					   	DeleteObject(hSedyStetec);
				 	  EndDialog(hwndDlg, LOWORD(wParam));
                      break;
                 }
             }
             return TRUE;
        }
        
    	
        
        case WM_PAINT: 
        {    PAINTSTRUCT ps;
             HDC hdc;
             hdc = BeginPaint(hwndDlg, &ps);
             SIZE size;
                           
			//========================================================================================================================
				//*
			// 1. Vytvorme pamov kontext (virtulne pltno)
		    HDC memDC = CreateCompatibleDC(hdc);
		    //rect na cel okno
		    RECT rect;
		    GetClientRect(hwndDlg, &rect);	
		    // 2. Vytvorme bitmapu, na ktor budeme "kresli"
		    HBITMAP hbmMem = CreateCompatibleBitmap(hdc, rect.right, rect.bottom);
		    HBITMAP hOldBm = (HBITMAP)SelectObject(memDC, hbmMem);
		    // 3. NAKRESLME POZADIE (textra zo zdrojov)
		    // Pouijeme tetec s textrou, ktor sme si vytvorili predtm
		    FillRect(memDC, &rect, hTexturaBrush);
		    // 4. "VYNUTE" PRVKY (tlaidl, editboxy), aby sa nakreslili do naej bitmapy
		    // Toto je trik pre dialgy: sprva WM_PRINT nahnev prvky, aby sa vykreslili do nho DC
		    SendMessage(hwndDlg, WM_PRINTCLIENT, (WPARAM)memDC, PRF_CLIENT | PRF_CHILDREN | PRF_ERASEBKGND);
		
			//LED psik nad tlatkom "Pripoji"/"Odpoji"
			//if(StavPripojeniaCOM == 1)
			 //	LedSvetlo(memDC, RGB(0,255,0), RGB(0,255,255), LedZaoblenie, rect_indikator);	
			 	//LedSvetlo(memDC, RGB(180,180,180), RGB(0,255,0), LedZaoblenie, rect_indikator);	
			// else
			 //	LedSvetlo(memDC, RGB(200,200,200), RGB(230,230,230), LedZaoblenie, rect_indikator);	
			 	//LedSvetlo(memDC, RGB(180,180,180), RGB(200,200,200), LedZaoblenie, rect_indikator);	
			 
		
		
		    // 5. FINLNY KROK: Skoprujeme vetko z pamte na relnu obrazovku naraz
		    BitBlt(hdc, 0, 0, rect.right, rect.bottom, memDC, 0, 0, SRCCOPY);
		    // Upratovanie
		    SelectObject(memDC, hOldBm);
		    DeleteObject(hbmMem);
		    DeleteDC(memDC);
		//*/
		
			/* 
		
		
		
			int VelkostPisma = 14,//20,//11,
				X_text = 10,//34,
				Y_text = 400;

			//Graficky rezim podporujuci zmenu logFont.lfOrientation pisma
			int GraphicModeOld = SetGraphicsMode (hdc, GM_ADVANCED);	//GM_COMPATIBLE			
			SetBkMode(hdc, TRANSPARENT);
			GetObject(GetStockObject(DEFAULT_GUI_FONT), sizeof(logFont), &logFont); 
			COLORREF ColorOld = SetTextColor(hdc, RGB(0,0,200));					
			lstrcpy(logFont.lfFaceName, "Segoe UI");
			//lstrcpy(logFont.lfFaceName, "Comic Sans MS");
			logFont.lfHeight = -MulDiv (VelkostPisma, GetDeviceCaps (hdc, LOGPIXELSY), 72);//-70; //Velkost pisma
			//logFont.lfWidth = 13; //Sirka pisma (ak je 0, pouzije sa automaticky najblizsia hodnota)
			logFont.lfWeight = 0;//600; //Tucne pismo
			//logFont.lfEscapement = 0;//-300;//900; //Uhol celeho textu (rotacia)
			//logFont.lfItalic = TRUE;
			//logFont.lfOrientation = 0;//-300;//900; //Zvisly text		
			HFONT hFont = CreateFontIndirect(&logFont);
			HFONT hFontOld = (HFONT)SelectObject(hdc, hFont); 
																								    				
		//	_stprintf(text, "%c%c%c%c%c %c%c%c%c%c %c%c%c", Cislo[0], Cislo[1], Cislo[2], Cislo[3], Cislo[4], Cislo[5], Cislo[6], Cislo[7], Cislo[8], Cislo[9], Cislo[10], Cislo[11], Cislo[12]);
			
			_stprintf(text, "%d  %d  %d  %d  %d  %d", 	AktivnePorty[0], 
														AktivnePorty[1], 
														StavPripojeniaCOM, 
														Aktualna_rychlost, 
														Aktualna_rychlost, 
														Pocet_existujucich_portov);
			//TextOut(hdc, X_text, Y_text, text, lstrlen(text));
			//GetTextExtentPoint32(hdc, text, lstrlen(text), &size);
			//vymaze aktualny text v textovom okienku TX
            SendDlgItemMessage(hwndDlg, ID_EDIT_TX_HISTORY, WM_SETTEXT, 0, 0); 
			// vlozi zadany text do textoveho editboxu
			SendDlgItemMessage(hwndDlg, ID_EDIT_TX_HISTORY, EM_REPLACESEL, FALSE, (LPARAM)text);
			//nastavi poziciu na zaciatok textu textoveho editboxu (wParam = zaciatok, lParam = koniec vyberu)
			//SendDlgItemMessage(hwndDlg, ID_EDIT_TX_HISTORY, EM_SETSEL, 0, 0);	
					
																
			SelectObject(hdc, hFontOld);
		    DeleteObject(hFont);
		    SetTextColor(hdc, ColorOld);
		    SetGraphicsMode (hdc, GraphicModeOld);
 			//*/
   
             
		//=================================================================================================================================
		             
			 EndPaint(hwndDlg, &ps);             
             return TRUE;
        }
        //*/
           
    }
    return FALSE;
}    






int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) 
{   
	EnableDPIAwareness(); // Podpora pre High DPI (Vysok rozlenie)
	g_hInstance = hInstance;
	INITCOMMONCONTROLSEX icc;
    icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
    icc.dwICC = ICC_WIN95_CLASSES;
    if ( !InitCommonControlsEx(&icc) )
       return FALSE;      
 	return DialogBox(hInstance, MAKEINTRESOURCE(IDD_DIALOG), NULL, (DLGPROC)ProceduraDialogu);	
}



/*
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) 
{   
	g_hInstance = hInstance;
	g_nCmdShow = nCmdShow;
	MSG Msg;
	int f;
	CreateDialog(GetModuleHandle(0), MAKEINTRESOURCE(IDD_DIALOG), NULL, (DLGPROC)ProceduraDialogu);	
	//cyklus sprav	    
	while(GetMessage(&Msg, 0, 0, 0) > 0) 
	{   TranslateMessage(&Msg); // Translate key codes to chars if present 
		DispatchMessage(&Msg); // Send it to WndProc 
	}
	return Msg.wParam;
}
//*/




//************************************************************************************************************************
//***************************************** U  I t O  N    F U N K C I E **********************************************
//************************************************************************************************************************
/*
//nastavi poziciu na zaciatok textu textoveho editboxu (wParam = zaciatok, lParam = koniec vyberu)
SendDlgItemMessage(hwndDlg, ID_EDIT_TX_HISTORY, EM_SETSEL, 0, 0);
//Zskanie HANDLE okna EditBoxu
HWND hwndEdit = GetDlgItem(hwndDlg, ID_EDIT_TX_HISTORY);
//plne vypneme prekresovanie na rovni sprv
SendMessage(hwndEdit, WM_SETREDRAW, FALSE, 0);
//Vlome text na tto pozciu
SendMessage(hwndEdit, EM_REPLACESEL, FALSE, (LPARAM)textTX);
//Nastavme vber na PLN KONIEC (pouijeme dku textu)
int ndx = GetWindowTextLength(hwndEdit);
SendMessage(hwndEdit, EM_SETSEL, (WPARAM)ndx, (LPARAM)ndx);
//Znovu zapneme prekresovanie
SendMessage(hwndEdit, WM_SETREDRAW, TRUE, 0);
//Dontime okno, aby sa prekreslilo naraz a isto
InvalidateRect(hwndEdit, NULL, TRUE);
UpdateWindow(hwndEdit);
// 1. Zskame dku aktulneho textu (kurzor na koniec)
int dlzka = GetWindowTextLength(hwndEdit);
// 2. Nastavme vber na samotn koniec (selection zana aj kon na dke textu)
SendMessage(hwndEdit, EM_SETSEL, (WPARAM)dlzka, (LPARAM)dlzka);
// 3. Nahradme "ni" (vber na konci) novm textom - tm ho prilepme
SendMessage(hwndEdit, EM_REPLACESEL, FALSE, (LPARAM)novyText);
// 4. Povieme oknu, aby odrolovalo k "strieke" (kurzoru).
//Automatick odrolovanie na koniec, aby bol text vdy viditen
SendMessage(hwndEdit, EM_SCROLLCARET, 0, 0);
// 1. Nastavme vber (kurzor) na pln koniec textu
// WPARAM -1 a LPARAM -1 v EM_SETSEL je skratka pre "pln koniec"
SendMessage(hwndEdit, EM_SETSEL, (WPARAM)-1, (LPARAM)-1);
// 2. Prilepme nov text (naprklad prijat reazec s novm riadkom)
SendMessage(hwndEdit, EM_REPLACESEL, FALSE, (LPARAM)"Nov riadok dt\r\n");
// 3. Povieme oknu, aby sa odrolovalo ku kurzoru (caret), teda nadol
SendMessage(hwndEdit, EM_SCROLLCARET, 0, 0);
//Znovu zapneme prekresovanie
SendMessage(hwndEdit, WM_SETREDRAW, TRUE, 0);
//Dontime okno, aby sa prekreslilo naraz a isto
InvalidateRect(hwndEdit, NULL, TRUE);
UpdateWindow(hwndEdit);
// Zkaz prekresovania
LockWindowUpdate(hwndEdit); 
//Povolenie prekresovania
LockWindowUpdate(NULL); 
//*/	


